<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_filter( 'plugins_api', function( $res, $action, $args ) {
    if (
        $action !== 'plugin_information' ||
        empty( $args->slug ) ||
        $args->slug !== OA_TEXT_DOMAIN
    ) {
        return $res;
    }

    global $wpdb;
    $domain = $_SERVER['HTTP_HOST'];

    // Fetch license from your custom table
    $row     = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT `key` FROM {$wpdb->prefix}org_wpcodequill WHERE domain = %s LIMIT 1",
            $domain
        ),
        ARRAY_A
    );
    $license = $row['key'] ?? '';

    if ( ! $license ) {
        return new WP_Error( 'no_license', 'License key not found.' );
    }

    // Fetch the same JSON
    $url      = add_query_arg( [
        'license' => $license,
        'domain'  => $domain,
        'plugin'  => OA_TEXT_DOMAIN,
    ], OA_UPDATE_ENDPOINT );
    $response = wp_remote_get( $url, [ 'timeout' => 15 ] );
    if ( is_wp_error( $response ) ) {
        return new WP_Error( 'api_error', 'Unable to fetch plugin info.' );
    }

    $data = json_decode( wp_remote_retrieve_body( $response ), true );
    if ( ! is_array( $data ) || empty( $data['version'] ) ) {
        return new WP_Error( 'api_invalid', 'Invalid plugin data.' );
    }

    // Build the object WP expects
    return (object) [
        'name'            => $data['name'],
        'slug'            => $data['slug'],
        'version'         => $data['version'],
        'plugin'          => OA_PLUGIN_FILE,
        'author'          => $data['author'],
        'author_homepage' => wp_strip_all_tags( $data['author'] ),
        'homepage'        => $data['homepage'],
        'tested'          => $data['tested']       ?? '',
        'requires'        => $data['requires']     ?? '',
        'last_updated'    => $data['last_updated'] ?? '',
        'download_link'   => $data['download_url'],
        'sections'        => $data['sections']     ?? [],
        'banners'         => $data['banners']      ?? [],
        'icons'           => $data['icons']        ?? [],
    ];
}, 10, 3 );
