<?php
function oa_plugin_activate() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'organic_addone_settings';
    $charset = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        header1_time INT NOT NULL DEFAULT 10,
        header4_time INT NOT NULL DEFAULT 8,
        organic_link TEXT NOT NULL DEFAULT '',
        image_url TEXT NOT NULL DEFAULT '',
        integrate_url TEXT  NOT NULL DEFAULT '', 
        redirect_page VARCHAR(10) NOT NULL DEFAULT '4',
        anti_adblocker_enabled TINYINT(1) NOT NULL DEFAULT 0,
        header_ads_code1 LONGTEXT NOT NULL DEFAULT '',
        header_ads_code2 LONGTEXT NOT NULL DEFAULT '',
        footer_ads_code1 LONGTEXT NOT NULL DEFAULT '',
        footer_ads_code2 LONGTEXT NOT NULL DEFAULT '',
        PRIMARY KEY (id)
    ) $charset;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    // Insert default row if not exists
    if (!$wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE id = 1")) {
        $wpdb->insert($table_name, [
            'header1_time' => 10,
            'header4_time' => 8,
            'redirect_page' => '4',
            'anti_adblocker_enabled' => 0
        ]);
    }
}
