<?php
require_once __DIR__ . '/admin-page.php';
require_once __DIR__ . '/form-handler.php';
require_once __DIR__ . '/functions.php';

class Organic_Addone_By_Wpcodequill {
    public function __construct() {
        add_action('admin_menu', [$this, 'add_menu']);
        add_action('admin_init', 'oa_handle_form_submission');
        add_action('init', 'oa_register_helpers');
    }

    public function add_menu() {
        // ✅ Top-level menu
        add_menu_page(
            'Organic Addone Settings',
            'Organic Addone',
            'manage_options',
            'organic-addone-admin',
            'oa_render_admin_page',
            'dashicons-admin-generic',
            56
        );

        // ✅ Submenu: Settings
        add_submenu_page(
            'organic-addone-admin',
            'Settings',
            'Settings',
            'manage_options',
            'organic-addone-admin',
            'oa_render_admin_page'
        );

        // ✅ Submenu: License
        add_submenu_page(
            'organic-addone-admin',
            'License Activation',
            'License',
            'manage_options',
            'organic-addone-license',
            [$this, 'render_license_page']
        );
    }

    // ✅ Render License Page
    public function render_license_page() {
        include plugin_dir_path(__FILE__) . '../license/index.php';
    }
}
