<?php
function oa_render_admin_page() {
    global $wpdb;
    $table = $wpdb->prefix . 'organic_addone_settings';
    $row   = $wpdb->get_row( "SELECT * FROM $table WHERE id = 1" );

    // existing settings...
    $h1         = esc_attr( $row->header1_time ?? 10 );
    $h4         = esc_attr( $row->header4_time ?? 8 );
    $ol         = esc_attr( $row->organic_link ?? '' );
    $iu         = esc_attr( $row->image_url ?? '' );
    $intu         = esc_attr( $row->integrate_url ?? '' );
    $ha1        = esc_textarea( $row->header_ads_code1 ?? '' );
    $ha2        = esc_textarea( $row->header_ads_code2 ?? '' );
    $fa1        = esc_textarea( $row->footer_ads_code1 ?? '' );
    $fa2        = esc_textarea( $row->footer_ads_code2 ?? '' );

    // NEW: pages & adblocker
    $redirect_page = esc_attr($row->redirect_page ?? '4');
    $adblock_status = isset($row->anti_adblocker_enabled) && $row->anti_adblocker_enabled ? 1 : 0;
    ?>
    <div class="wrap organic-settings-wrap">
      <h1>Organic Addone Settings By WPcodeQuill.com</h1>
      <form method="post" action="<?php echo esc_url( admin_url('options-general.php?page=organic-addone-admin') ); ?>">
        <?php wp_nonce_field('organic_addone_save','organic_addone_nonce'); ?>

        <fieldset class="organic-group">
          <legend>Step Timer Settings</legend>
          <label>Step 1 Header Timer (seconds)
            <input type="number" name="header1_time" value="<?php echo $h1; ?>" min="1" required>
          </label>
          <label>Step 2 (Header 4) Timer (seconds)
            <input type="number" name="header4_time" value="<?php echo $h4; ?>" min="1" required>
          </label>
        </fieldset>

        <fieldset class="organic-group">
          <legend>Link & Image Settings</legend>
          <label>Step 1 “Organic” Link URL
            <input type="url" name="organic_link" value="<?php echo $ol; ?>" placeholder="https://">
          </label>
          <label>Step 1 Image URL
            <input type="url" name="image_url" value="<?php echo $iu; ?>" placeholder="https://">
          </label>
          <label>Multi Domain/AdlinkFly Link
            <input type="url" name="integrate_url" value="<?php echo $intu; ?>" placeholder="https://">
          </label>
        </fieldset>
<fieldset class="organic-group">
<legend>Pages & Adblocker Settings</legend>
<label>Redirect Page
    <select name="redirect_page">
        <option value="2" <?php selected($redirect_page, '2'); ?>>2 Page</option>
        <option value="4" <?php selected($redirect_page, '4'); ?>>4 Page</option>
    </select>
</label>

<label>Anti-AdBlocker
    <select name="anti_adblocker_enabled">
        <option value="1" <?php selected($adblock_status, 1); ?>>Enabled</option>
        <option value="0" <?php selected($adblock_status, 0); ?>>Disabled</option>
    </select>
</label>
   </fieldset>
        <fieldset class="organic-group">
          <legend>Ad Code Settings</legend>
          <label>Header Ads 1<textarea name="header_ads_code1" rows="4"><?php echo $ha1; ?></textarea></label>
          <label>Header Ads 2<textarea name="header_ads_code2" rows="4"><?php echo $ha2; ?></textarea></label>
          <label>Footer Ads 1<textarea name="footer_ads_code1" rows="4"><?php echo $fa1; ?></textarea></label>
          <label>Footer Ads 2<textarea name="footer_ads_code2" rows="4"><?php echo $fa2; ?></textarea></label>
        </fieldset>

        <?php submit_button('Save Changes'); ?>
      </form>
    </div>

    <style>
      .organic-settings-wrap { background: #f9f9f9; padding:20px; border-radius:10px; max-width:800px; }
      .organic-group { background:#fff; border:1px solid #ccc; margin-bottom:20px; padding:15px; border-radius:6px; }
      .organic-group label { display:block; margin-bottom:15px; }
      input[type="number"], input[type="url"], textarea, select { width:100%; padding:8px; }
    </style>
    <?php
}
