<!-- header_2nd.php -->
<?php
// Fetch the values from the plugins table:
$time       = oa_get_header1_time();   // e.g. 13
$hads1 = oa_get_header_ads_code1();
$hads2 = oa_get_header_ads_code2();
?>

<style>
/* Button styling with 3D RGB effect using outer shadow (same as header 1) */
.tp-btn2 {
    position: relative;
    padding: 10px 20px;
    font-size: 12px;
    font-weight: 700;
    text-transform: uppercase;
    border: 3px solid;
    border-image-slice: 1;
    border-width: 3px;
    border-image-source: linear-gradient(45deg, red, orange, yellow, green, blue, indigo, violet);
    background: linear-gradient(to bottom, #6c02de 0%, #000be3 100%);
    color: #fff;
    cursor: pointer;
    overflow: hidden;
    transition: 0.2s ease, transform 0.2s ease, box-shadow 0.2s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.3), 0 8px 12px rgba(0,0,0,0.2);
}

/* Hover effect (lifted) */
.tp-btn2:hover {
    transform: translateY(-2px);
    background: linear-gradient(to bottom, #7b0cff 0%, #0010ff 100%);
    box-shadow: 0 6px 10px rgba(0,0,0,0.35), 0 12px 16px rgba(0,0,0,0.25);
}

/* Active (pressed) effect */
.tp-btn2:active {
    transform: translateY(2px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.2), 0 4px 8px rgba(0,0,0,0.15);
}

/* Step box container */
.tp-step-box2 {
    font-family: 'Open Sans', sans-serif;
    text-align: center;
    margin-top: 20px;
}

/* Step alert styling (gradient heading) */
.alert {
    color: #131bf2;
    font-size: 18px;
    font-weight: 700;
    background: linear-gradient(90deg, #6c02de, #000be3);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin-bottom: 20px;
    display: inline-block;
}

/* Tip text styling with animated gradient and shadow */
#tp-text2 {
    font-size: 16px;
    font-weight: 600;
    margin-top: 15px;
    display: inline-block;
    padding: 12px 18px;
    border-radius: 12px;
    font-family: 'Open Sans', sans-serif;
    background: linear-gradient(270deg, #6c02de, #000be3, #7b0cff, #0010ff);
    background-size: 800% 800%;
    color: #fff;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    animation: gradientShift 8s ease infinite;
}

#tp-text2 b {
    color: red;
}

/* Gradient animation keyframes */
@keyframes gradientShift {
    0% { background-position: 0% 50%; }
    50% { background-position: 100% 50%; }
    100% { background-position: 0% 50%; }
}
</style>

<div class="tp-step-box2">  
    <div class="alert">
        You are currently on step <span style="color:red;">2/4</span>.
    </div>  

    <center>
        <button id="header-2nd" class="tp-btn2">
            Please Wait <span id="countdown2"><?php echo intval($time); ?></span> Seconds...
        </button>
    </center>  

    <center><?php if (!empty($hads1)) echo $hads1; ?></center>
    <center><?php if (!empty($hads2)) echo $hads2; ?></center>

    <center>
        <h4 id="tp-text2" style="display:none;">
            Scroll down
        </h4>
    </center>
</div>

<script>
let timeLeft2 = <?php echo intval($time); ?>;
const countdown2 = document.getElementById("countdown2");
const btn2 = document.getElementById("header-2nd");
const tip2 = document.getElementById("tp-text2");

const timer2 = setInterval(() => {
    timeLeft2--;
    countdown2.textContent = timeLeft2;
    if (timeLeft2 <= 0) {
        clearInterval(timer2);
        btn2.style.display = "none";
        tip2.style.display = "block";
        document.dispatchEvent(new Event('header2ndComplete'));
    }
}, 1000);
</script>