<?php 
$fads1 = oa_get_footer_ads_code1(); 
$fads2 = oa_get_footer_ads_code2(); 

// Fetch a random post
$random_post_obj = get_posts(array(
    'posts_per_page' => 1,
    'orderby'        => 'rand',
    'post_status'    => 'publish',
))[0];

$random_post_url   = get_permalink($random_post_obj->ID);
$random_post_title = get_the_title($random_post_obj->ID);
?>

<div id="countdown-container" style="text-align:center; margin-top: 20px;">
    <span id="countdown-text">Please wait 10 seconds...</span>
</div>

<div id="footer-3rd" style="text-align:center; margin-top: 20px; display:none;">
    <button id="btn6" class="tp-btn3"><?php echo esc_html($random_post_title); ?></button>
</div>

<!-- Ads always visible -->
<div id="f1-ads" style="text-align:center; margin-top:20px;"> 
    <?php if (!empty($fads1)) echo $fads1; ?>
</div>

<div id="f1-ads2" style="text-align:center; margin-top:20px;"> 
    <?php if (!empty($fads2)) echo $fads2; ?>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    let countdown = 10; // 10-second timer
    const countdownText = document.getElementById('countdown-text');
    const btn = document.getElementById('btn6');

    const timer = setInterval(() => {
        countdownText.innerText = `Please wait ${countdown} second${countdown > 1 ? 's' : ''}...`;
        countdown--;
        if (countdown < 0) {
            clearInterval(timer);
            // Hide countdown and show button
            document.getElementById('countdown-container').style.display = 'none';
            document.getElementById('footer-3rd').style.display = 'block';
        }
    }, 1000);

    // Button click: redirect to random post in same tab
    btn.addEventListener('click', function () {
        window.location.href = "<?php echo esc_url($random_post_url); ?>";
    });
});
</script>