<?php
if ( ! defined( 'ABSPATH' ) ) exit;

$fads1 = oa_get_footer_ads_code1();
$fads2 = oa_get_footer_ads_code2();

// Fetch a random post
$random_post_obj = get_posts(array(
    'posts_per_page' => 1,
    'orderby'        => 'rand',
    'post_status'    => 'publish',
))[0];

$random_post_url   = get_permalink($random_post_obj->ID);
$random_post_title = get_the_title($random_post_obj->ID);
?>

<br>
<!-- Ads before the flow (always visible) -->
<div id="f1-ads" style="text-align:center; margin-top:20px;">
  <?php if (!empty($fads1)) echo $fads1; ?>
</div>
<br>

<!-- Continue + Loader -->
<center>
  <button id="btn6" class="tp-btn" style="display:none;"><?php echo esc_html($random_post_title); ?></button>
  <button id="btn-loader" class="tp-btn" style="display:none;">Please wait…</button>
</center>
<br>

<!-- Ads after the flow (always visible) -->
<div id="f2-ads" style="text-align:center; margin-top:20px;">
  <?php if (!empty($fads2)) echo $fads2; ?>
</div>
<br>

<script>
// Show Continue button when header1stComplete fires
document.addEventListener('header1stComplete', () => {
    document.getElementById('btn6').style.display = 'inline-block';
});

// Loader + redirect to random post
document.getElementById('btn6').addEventListener('click', () => {
    const btn     = document.getElementById('btn6');
    const loader  = document.getElementById('btn-loader');

    // Hide button, show loader
    btn.style.display    = 'none';
    loader.style.display = 'inline-block';

    let countdown = 5; // or your original countdown
    const iv = setInterval(() => {
        countdown--;
        if (countdown <= 0) {
            clearInterval(iv);
            loader.style.display = 'none';
            btn.style.display    = 'inline-block';
            // Trigger next step
            document.dispatchEvent(new Event('footer1stComplete'));
        }
    }, 1000);

    // Open random post in new tab
    window.open("<?php echo esc_url($random_post_url); ?>", '_blank');
});
</script>