<?php
/**
 * Supplies the HTML / changelog for the “View version details” pop-up.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'OA_TEXT_DOMAIN'     ) ) define( 'OA_TEXT_DOMAIN',     'organic-safelink-4-page-plugin' );
if ( ! defined( 'OA_PLUGIN_FILE'     ) ) define( 'OA_PLUGIN_FILE',     'organic-safelink-4-page-plugin/organic-safelink-4-page-plugin.php' );
if ( ! defined( 'OA_UPDATE_ENDPOINT' ) ) define( 'OA_UPDATE_ENDPOINT', 'https://admin.wpcodequill.com/my-admin/update/update-info.php' );

/* ---------------------------------------------------------------------------
 * Filter: WP calls this when user clicks “View details”
 * ------------------------------------------------------------------------ */
add_filter( 'plugins_api', function ( $res, $action, $args ) {

	/* 0. bail if it isn’t our plugin */
	if ( $action !== 'plugin_information' || empty( $args->slug ) || $args->slug !== OA_TEXT_DOMAIN ) {
		return $res;
	}

	/* 1. fetch licence key */
	global $wpdb;
	$table  = $wpdb->prefix . 'org_wpcodequill';
	$domain = strtolower( preg_replace( '/^www\./i', '', $_SERVER['HTTP_HOST'] ) );

	$license = $wpdb->get_var(
		$wpdb->prepare(
			"SELECT `key`
			   FROM {$table}
			  WHERE `domain` = %s
			    AND `plugin` = %s
			  LIMIT 1",
			$domain,
			OA_TEXT_DOMAIN
		)
	);

	if ( ! $license ) {
		return new WP_Error( 'no_license', __( 'Licence key not found.', OA_TEXT_DOMAIN ) );
	}

	/* 2. call endpoint */
	$url = add_query_arg(
		[
			'license' => $license,
			'domain'  => $domain,
			'plugin'  => OA_TEXT_DOMAIN,
		],
		OA_UPDATE_ENDPOINT
	);

	$response = wp_remote_get( $url, [ 'timeout' => 15 ] );
	if ( is_wp_error( $response ) ) {
		return new WP_Error( 'api_error', __( 'Unable to fetch plugin info.', OA_TEXT_DOMAIN ) );
	}

	$data = json_decode( wp_remote_retrieve_body( $response ), true );
	if ( ! is_array( $data ) || empty( $data['version'] ) ) {
		return new WP_Error( 'api_invalid', __( 'Invalid plugin data.', OA_TEXT_DOMAIN ) );
	}

	/* 3. very light sanitising – keep headings, lists, links */
	$allowed = wp_kses_allowed_html( 'post' );
	foreach ( [ 'description', 'installation', 'changelog', 'faq' ] as $sec ) {
		if ( ! empty( $data['sections'][ $sec ] ) ) {
			$data['sections'][ $sec ] = wp_kses( $data['sections'][ $sec ], $allowed );
		}
	}

	/* 4. return what WP expects */
return (object) [
	'name'            => $data['name'],
	'slug'            => $data['slug'],
	'version'         => $data['version'],
	'plugin'          => OA_PLUGIN_FILE,
	'author'          => $data['author'],
	'author_homepage' => wp_strip_all_tags( $data['author'] ),
	'homepage'        => $data['homepage'],
	'tested'          => $data['tested']       ?? '',
	'requires'        => $data['requires']     ?? '',
	'requires_php'    => $data['requires_php'] ?? '',   // ← NEW
	'last_updated'    => $data['last_updated'] ?? '',   // ← NEW
	'download_link'   => $data['download_url'],
	'sections'        => $data['sections']     ?? [],
	'banners'         => $data['banners']      ?? [],
	'icons'           => $data['icons']        ?? [],
];

}, 10, 3 );
