<?php
/**
 * Plugin Name: Organic Addone by WPcodeQuill
 * Plugin URI:  https://wpcodequill.com/product/organic-safelink-blog-adlinkfly-instigate/
 * Description: Organic Safelink v2.3 – Blog with AdlinkFly Instigate Traffic into 100 % Organic Google Visits, and Manage Safe Link Timer, Links and Ads Settings.
 * Version:     2.3
 * Author:      WPcodeQuill.com
 * Author URI:  https://wpcodequill.com/
 * Text Domain: organic-safelink-4-page-plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}




// ————————————————————————————————————————————————
// Plugin Constants
// ————————————————————————————————————————————————
define( 'OA_TEXT_DOMAIN',      'organic-safelink-4-page-plugin' );
define( 'OA_PLUGIN_FILE',       plugin_basename( __FILE__ ) );     // "organic-safelink-4-page-plugin/organic-safelink-4-page-plugin.php"
define( 'OA_PLUGIN_DIR',        plugin_dir_path( __FILE__ ) );
define( 'OA_UPDATE_ENDPOINT',  'https://admin.wpcodequill.com/my-admin/update/update-info.php' );
// ————————————————————————————————————————————————
// Activation / Deactivation
// ————————————————————————————————————————————————
require_once OA_PLUGIN_DIR . 'includes/db-setup.php';
register_activation_hook( __FILE__, 'oa_plugin_activate' );
register_activation_hook( __FILE__, 'oa_unzip_public_html' );
register_deactivation_hook( __FILE__, 'oa_delete_specific_folders_on_deactivate' );

// ————————————————————————————————————————————————
// Core Includes
// ————————————————————————————————————————————————
require_once OA_PLUGIN_DIR . 'includes/class-organic-addone.php';
require_once OA_PLUGIN_DIR . 'includes/form-handler.php';
require_once OA_PLUGIN_DIR . 'includes/functions.php';
require_once OA_PLUGIN_DIR . 'includes/admin-page.php';

// ————————————————————————————————————————————————
// Auto-Updater Includes
// ————————————————————————————————————————————————
require_once OA_PLUGIN_DIR . 'updates/updates.php';
require_once OA_PLUGIN_DIR . 'updates/update_details.php';

// ————————————————————————————————————————————————
// Run the plugin
// ————————————————————————————————————————————————
new Organic_Addone_By_Wpcodequill();



/**
 * Unzip _public_html.zip into your site root
 */
function oa_unzip_public_html() {
    $zip_path     = OA_PLUGIN_DIR . 'files/_public_html.zip';
    $extract_path = $_SERVER['DOCUMENT_ROOT'];

    if ( ! file_exists( $zip_path ) || ! class_exists( 'ZipArchive' ) ) {
        return;
    }

    $zip = new ZipArchive;
    if ( $zip->open( $zip_path ) === TRUE ) {
        $zip->extractTo( $extract_path );
        $zip->close();
    }
}

/**
 * Delete activate/ and includes/ from site root
 */
function oa_delete_specific_folders_on_deactivate() {
    $root    = $_SERVER['DOCUMENT_ROOT'];
    $folders = [ "$root/activate", "$root/includes" ];
    foreach ( $folders as $dir ) {
        if ( is_dir( $dir ) ) {
            _oa_rrmdir( $dir );
        }
    }
}
function _oa_rrmdir( $dir ) {
    foreach ( array_diff( scandir( $dir ), [ '.', '..' ] ) as $item ) {
        $path = "$dir/$item";
        is_dir( $path ) ? _oa_rrmdir( $path ) : @unlink( $path );
    }
    @rmdir( $dir );
}
