<?php
function oa_handle_form_submission() {
    if (isset($_GET['page']) && $_GET['page'] === 'organic-addone-admin') {
        if (
            isset($_POST['organic_addone_nonce']) &&
            wp_verify_nonce($_POST['organic_addone_nonce'], 'organic_addone_save') &&
            current_user_can('manage_options')
        ) {
            global $wpdb;
            $table = $wpdb->prefix . 'organic_addone_settings';

            $data = [
                'header1_time'       => absint($_POST['header1_time']),
                'header4_time'       => absint($_POST['header4_time']),
                'organic_link'       => sanitize_text_field($_POST['organic_link']),
                'image_url'          => sanitize_text_field($_POST['image_url']),
                'integrate_url'      => sanitize_text_field($_POST['integrate_url']),
                'header_ads_code1'   => wp_unslash($_POST['header_ads_code1']),
                'header_ads_code2'   => wp_unslash($_POST['header_ads_code2']),
                'footer_ads_code1'   => wp_unslash($_POST['footer_ads_code1']),
                'footer_ads_code2'   => wp_unslash($_POST['footer_ads_code2']),
                'redirect_page'           => sanitize_text_field($_POST['redirect_page']),
                'anti_adblocker_enabled'  => isset($_POST['anti_adblocker_enabled']) ? (int) $_POST['anti_adblocker_enabled'] : 0,

            ];

            $wpdb->update($table, $data, ['id' => 1]);
            wp_redirect(add_query_arg(['page' => 'organic-addone-admin', 'updated' => 'true'], admin_url('options-general.php')));
            exit;
        }
    }
}
