<?php
// File: /includes/adblock-detect.php
?>
<!-- ✅ Robust Anti-AdBlock Popup -->
<style>
#adblock-warning {
  display: none;
  position: fixed;
  top: 50%; left: 50%;
  transform: translate(-50%, -50%);
  background: #fff;
  border: 2px solid red;
  padding: 30px;
  border-radius: 12px;
  z-index: 999999;
  width: 90%;
  max-width: 480px;
  font-family: Arial, sans-serif;
  box-shadow: 0 0 20px rgba(0,0,0,0.3);
  text-align: center;
}
#adblock-warning h2 {
  font-size: 24px;
  margin-bottom: 12px;
  color: #c00;
}
#adblock-warning p {
  font-size: 16px;
}
</style>

<div id="adblock-warning">
  <h2>🚫 Ad Blocker Detected!</h2>
  <p>Please disable your ad blocker to continue using this website.</p>
  <button onclick="location.reload()" style="
    margin-top: 20px;
    padding: 10px 20px;
    background: #c00;
    color: #fff;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    cursor: pointer;
  ">🔄 Reload Page</button>
</div>

<script>
// ✅ Anti-AdBlocker Trick: load fake ad script
function detectAdBlock() {
  let adScript = document.createElement('script');
  adScript.src = 'https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js';
  adScript.async = true;
  adScript.onerror = function () {
    showAdblockPopup(); // Blocker blocked it!
  };
  document.head.appendChild(adScript);

  // ✅ fallback: test dummy ad element visibility
  setTimeout(() => {
    let bait = document.createElement('div');
    bait.className = 'adsbygoogle';
    bait.style.cssText = 'width:1px;height:1px;position:absolute;left:-9999px;';
    document.body.appendChild(bait);
    const blocked = bait.offsetHeight === 0 || getComputedStyle(bait).display === "none";
    bait.remove();
    if (blocked) showAdblockPopup();
  }, 500);
}

function showAdblockPopup() {
  const popup = document.getElementById("adblock-warning");
  if (popup) {
    popup.style.display = "block";
    document.body.style.overflow = "hidden"; // optional
  }
}

document.addEventListener("DOMContentLoaded", detectAdBlock);
</script>
