<?php
// safe.php (Step 0: Show image + timer, then redirect to Google) code by wpcodequill.com

require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');

// Use plugin helper functions
$imgurl  = function_exists('oa_get_image_url')   ? oa_get_image_url()   : '';
$organic = function_exists('oa_get_organic_link') ? oa_get_organic_link() : '';

// Get the current domain name
$domain = $_SERVER['HTTP_HOST'];
$domain = preg_replace('/^www\./', '', $domain); // Remove 'www.' if present

$slug = $_GET['link'] ?? '';
if (!$slug) exit('Invalid link');



// Set main cookies  code by wpcodequill.com
setcookie("tp", $slug, time() + 3600, "/", ".$domain");
setcookie("tp_step", "1", time() + 3600, "/", ".$domain");
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Redirecting... Please wait</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://fonts.googleapis.com/css?family=Raleway:400,900' rel='stylesheet'>
</head>
<body style="font-family: Raleway, sans-serif; text-align: center;">

    <img src="<?php echo esc_url($imgurl); ?>" style="max-height: 500px; width: auto; margin-top: 20px;"><br><br>
    <p><strong>Redirecting, please wait...</strong></p>
    <p>You will be redirected to Google in <span id="wpsafe-time">3</span> seconds.</p>
    <p><strong>Click the first link from Google to continue to your download.</strong></p>

    <script>
        var count = 3;
        var counter = setInterval(function () {
            count--;
            document.getElementById("wpsafe-time").innerText = count;
            if (count <= 0) {
                clearInterval(counter);
                window.location.href = <?= json_encode($organic) ?>;
            }
        }, 1500);
    </script>

</body>
</html>
