<?php
// public_html/includes/function.php

// 1) Bootstrap WP so we can use $wpdb
if ( ! defined('ABSPATH') ) {
    define('ABSPATH', dirname(__DIR__) . '/');
    require_once ABSPATH . 'wp-load.php';
}

global $wpdb;
$table = $wpdb->prefix . 'organic_addone_settings';

// 2) Pull both flags in one go
$row = $wpdb->get_row( "
    SELECT redirect_page, anti_adblocker_enabled 
    FROM {$table} 
    WHERE id = 1
" );

// 3) Coerce to ints (default to 2 pages / disabled adblock)
$redirect          = isset( $row->redirect_page ) ? (int) $row->redirect_page : 2;
$anti_adblocker_on = ! empty( $row->anti_adblocker_enabled );

// 1) If anti-adblocker is enabled, include its detector
if ( $anti_adblocker_on ) {
    require_once __DIR__ . '/adblocker.php';
}

$GLOBALS['oa_template_id'] = ( $redirect === 4 ) ? 4 : 2;

// 5) Include the correct flow file from includes/
if ( $redirect === 2 ) {
    require_once __DIR__ . '/function2pages.php';
} elseif ( $redirect === 4 ) {
    require_once __DIR__ . '/function4pages.php';
} else {
    // fallback to 2-page flow
    require_once __DIR__ . '/function2pages.php';
}

// …any other setup…
